﻿#include "gameFunctions/copyObject.as"
storeSave = function(saveData, gameId)
{
	var gameId = (gameId) ? gameId : "humbird0_rpg";
	if(saveData)
	{
		// access saved data
		var srm = SharedObject.getLocal(gameId);
		// clear previous saved data
		srm.clear();
		// store data
		srm.data.ram = {};
		copyObject(RAM, srm.data.ram);
		// write data to disk now
		var success = srm.flush();
		
		if(success==true){
//			trace("Save Successful");
			return true;
		}else{
			trace("Save Failed");
			return false;
		}
	}// if:  there's data to save
}// storeSave()



saveGame = function( gameId )
{
	//trace("save - RAM.swfLoader.permSwf: "+RAM.swfLoader.permSwf);
//	trace("\n saveGame()");
	if(ROOT.level_xml.filePath)
	{// if:  a level is loaded
		// store current level
		RAM.saveSettings = {};
		RAM.saveSettings.level = ROOT.level_xml.filePath;
	
		// store player appearance
		if(SPRITES.player)
		{// if:  player exists
			var currentPlayer = SPRITES.player.image.getParams();
			if(currentPlayer)
				RAM.playerSprite = currentPlayer;
			// store player location
			RAM.saveSettings.playerPosition = {
				x:SPRITES.player._x,
				y:SPRITES.player._y
			}// playerPosition
		}// if:  player exists
		
		// store audio settings
		RAM.saveSettings.music = {
			songName:MUSIC.songName,
			isPlaying:MUSIC.isPlaying,
			volume:MUSIC.volume,
			songVolume:MUSIC.songVolume
		}// music
		// NOTE:  looping sounds are NOT stored
		RAM.saveSettings.sound = {
			volume:SOUND.volume
		}// sound
		
		// Save the game  (copy RAM to saveData)
		var saveData = {};
		copyObject(RAM, saveData);
		var result = storeSave( saveData, gameId );
	}// if:  a level is loaded
	return result;
}// saveGame